//
//  GHBatteryData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 3/9/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//


#import <Foundation/Foundation.h>


/**
 *  Battery status values.
 */
typedef NS_ENUM(uint32_t, GHBatteryStatus) {
    /** The battery status is unknown */
    GHBatteryStatusUnknown = 0,
    
    /** The battery status is new */
    GHBatteryStatusNew = 1,
    
    /** The battery status is good */
    GHBatteryStatusGood = 2,
    
    /** The battery status is OK */
    GHBatteryStatusOK = 3,
    
    /** The battery status is low */
    GHBatteryStatusLow = 4,
    
    /** The battery status is critical */
    GHBatteryStatusCritical = 5,
    
    /** The battery status is charging */
    GHBatteryStatusCharging = 6,
    
    /** The battery status is invalid */
    GHBatteryStatusInvalid = 7
};

#pragma mark -
/**
 *  The GHBatteryData class provides information about
 *  the state of the battery as reported by the device.
 */
@interface GHBatteryData : NSObject

/** The timestamp for the reading. Can be null. */
@property (nullable, nonatomic, readonly) NSDate *timestamp;

/** The status of the battery. Refer to GHBatteryStatus for additional information.*/
@property (nonatomic, readonly) GHBatteryStatus status;

/** The voltage of the battery. Can be null. */
@property (nullable, nonatomic, readonly) NSNumber *voltage;



@end
